#version 330
#extension GL_EXT_gpu_shader4 : enable
// Kaleidescope PlanetariumMod01.fsh  by   j91000

//https://www.shadertoy.com/view/WlSfWy
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
uniform int       iFrame;

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//render settings
#define GSPEED .8 //global time speed factor
#define TOFF iMouse.x*.01-.62 //global time offset
#define MAXSTEPS 1000
#define CAMDIST 5.//camera distance from target
#define CAMSTRT vec2(-PI/4.,0.)

#define HITDIST 1.e-2
#define MAXDIST 1000.

//misc
#define ZERO min(iFrame,0)

//light and shadow
#define AMBIENT 0.15 
#define SUNDIR normalize(vec3(-0.,1.,1.))
#define SUNLIGHT vec3(.7,.6,.5)*6.91
#define FOGDIST 1.0e-2
#define FOGCOL vec3(.01,.01,.02)

#define SHADQUAL .8
#define SHADSMOOTH 150.
#define SPECULARPOWER 10.
//ambient occlusion
#define AO 1. //comment this line to disable ambient occlusion
#define AODIST 0.6
#define AOSTEPS 8
#define AOPOW .6
// start prevoid Common  //
//THANKS TO THE HG_SDF LIBRARY
#define PI 3.14159265
#define TAU (2*PI)
#define PHI (sqrt(5)*0.5 + 0.5)
// Repeat around the origin by a fixed angle.
// For easier use, num of repetitions is use to specify the angle.
float pModPolar(inout vec2 p, float repetitions) {
	float angle = 2.*PI/repetitions;
	float a = atan(p.y, p.x) + angle/2.;
	float r = length(p);
	float c = floor(a/angle);
	a = mod(a,angle) - angle/2.;
	p = vec2(cos(a), sin(a))*r;
	// For an odd number of repetitions, fix cell index of the cell in -x direction
	// (cell index would be e.g. -5 and 5 in the two halves of the cell):
	if (abs(c) >= (repetitions/2.)) c = abs(c);
	return c;
}


float pModSingle1(inout float p, float size) {
	float halfsize = size*0.5;
	float c = floor((p + halfsize)/size);
	if (p >= 0.)
		p = mod(p + halfsize, size) - halfsize;
	return c;
}

float pReflect(inout vec3 p, vec3 planeNormal, float offset) {
	float t = dot(p, planeNormal)+offset;
	if (t < 0.) {
		p = p - (2.*t)*planeNormal;
	}
	return sign(t);
}
//end prevoid common //
struct CastResult
{
    vec3 ori;
    vec3 pos; //hit location
    vec3 norm; //surface normal
    vec3 surf; //surface material/albedo
};
struct DirLight
{
  	vec3 dir; //light direction vector
    vec3 col; //light color*intensity
};
struct MapResult
{
    float dist;//distance to scene
    vec3 color;//surface material color
};
//Returns a rotation matrix for the given angles around the X,Y,Z axes.
mat3 Rotate(vec3 angles)
{angles=angles.yxz;
    vec3 c = cos(angles);
    vec3 s = sin(angles);
    
    mat3 rotX = mat3( 1.0, 0.0, 0.0, 0.0,c.x,s.x, 0.0,-s.x, c.x);
    mat3 rotY = mat3( c.y, 0.0,-s.y, 0.0,1.0,0.0, s.y, 0.0, c.y);
    mat3 rotZ = mat3( c.z, s.z, 0.0,-s.z,c.z,0.0, 0.0, 0.0, 1.0);
        return rotX*rotY*rotZ;
    }

mat3 Rotate(float a1,float a2,float a3){
 return Rotate(vec3(a1,a2,a3));   
}
//generates a rotation matrix that rotates (0,0,1) to face in the same
//direction as dir.
mat3 camRotation(vec3 dir){
    dir=normalize(dir);
    float xRot=atan(dir.z,dir.x)-PI/2.;
    float yRot=atan(dir.y,length(dir.xz));
    return Rotate(vec3(xRot,yRot,0));
}
MapResult sdUnion(MapResult a,MapResult b){
    if(a.dist<b.dist){return a;}
    return b;
}
MapResult sdIntersect(MapResult a,MapResult b){
    if(a.dist<b.dist){return b;}
    return a;
}
MapResult sdSub(MapResult a,MapResult b){
    b.dist*=-1.;
    if(a.dist>b.dist){return a;}
    return b;
}
MapResult sdTorus( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return MapResult(length(q)-t.y,vec3(.2));
}

MapResult sdVBall(vec3 pos,float scal,vec3 col){
return MapResult(length(pos)-1.*scal,col);
}

MapResult sdVBall(vec3 pos,float scal){
 return sdVBall(pos,scal,vec3(.2,.2,.15));
}

#define RECURSION 15
//calculate the distance to scene/ material properties of closest object
//this function is a mess, as i fiddled with it for ages. I attempt to explain what 
//each line is doing. 
MapResult map(vec3 pos){
    vec3 oldPos=pos;
    
    
    vec3 starPos=pos+vec3(60.,80.,0.);//establish the center of the star-ball
	starPos=abs(starPos+vec3(3.,0.,0.));//make sure we are in the part thats getting mirrored
    starPos=starPos*Rotate((iTime*GSPEED+TOFF)/18.,0.,0.);//add some time shifting rotation
    float c1=pModPolar(starPos.xy,20.);//fold space for the star replication
    starPos=starPos*Rotate((iTime*GSPEED+TOFF)/25.,0.,0.);//time shift for the other axis
    float c2=pModPolar(starPos.xz,20.);//fold again along a different axis
    float c3=pModSingle1(starPos.x,10.);//the last fold, duplicating along a ray
    vec3 cell=vec3(c1,c2,c3);//this is the identifier for which instance of the ball we ended up in
    //now we get the actual signed distance of our domain repeated primitive:
    float starsize=.1+1.5*abs(sin(1.*length(cell)));//starsize depends on cell
    vec3 color=abs(cos(cell/2.5))/2.;//so does color
    //here we make the primitive call with domain repeated starPos
    MapResult stars=sdVBall(starPos,starsize,color);
    stars=sdSub(stars,sdVBall(oldPos,30.));//remove any stars that happen to fall inside our viewing area.
    
    //now construct the "structure"
    float size=5.;
    float tVar=1.+.1*sin((iTime*GSPEED+TOFF)/5.);//controls the planetarium timing stuff
    vec3 norm=vec3(1.,0.,0.);//initial norm to reflect across
    for(int i=0;i<RECURSION;i++){
        norm=norm*Rotate(.01,0.1,.6*sin(tVar));//little rotation each iteration
        pReflect(pos,norm,0.);//reflect along norm
        
    }
    MapResult result=sdTorus(pos,vec2(size*4.,size*1.));//this is the primitive that defines the structure
    
    result.color=smoothstep(vec3(0.),vec3(.2),.05+.1*pow(abs(pos.xyz/4.),vec3 (-.4)));//color just based on sin(pos). neat little rainbow
    
    result= sdUnion(result,stars);//union the structure and the stars.
    return result;
}
//same as map, but throw away everything but distance
float distToScene(vec3 pos){
 return map(pos).dist;   
}
//calculate the norm by sampling the distance field around pos
//lifted from an iq raymarcher
vec3 calcNorm(vec3 pos){
        vec3 n = vec3(0.0);
    for( int i=ZERO; i<4; i++ )
    {
        vec3 e = 1.*(2.0*vec3((((i+3)>>1)&1),((i>>1)&1),(i&1))-1.0);
        n += e*distToScene(pos+0.005*e);
    }
    return normalize(n);
}

//clever ambient occlusion trick described here:
//https://iquilezles.org/www/material/nvscene2008/rwwtt.pdf
float ambientOcclusion(vec3 pos,vec3 normal,float sampleDist,float aoPower){
    #ifdef AO
    float occlusion=0.;
    float itC=0.;
    for(int i=1;i<AOSTEPS;i++){
     itC++;
     float term=itC*sampleDist-distToScene(pos+normal*sampleDist*itC);
        occlusion+=1./pow(2.,itC)*term;
    }
    return 1.-clamp(aoPower*occlusion/sampleDist,0.,1.);
    #else
    return 1.;
    #endif
}
float ambientOcclusion(vec3 pos,vec3 normal,float sampleDist){
    return ambientOcclusion(pos,normal,sampleDist,AOPOW);
}

//cast a new ray from surface.pos and see if you hit anything 
//on your way to sun
//this ray marching procedure is a variation of primaryRay()
float occlusion(CastResult surface,DirLight sun){
    vec3 rayOri=surface.pos+surface.norm*HITDIST*2.;//the ray starts from just above the surface of the hit.
    vec3 rayPos=rayOri;//start at rayOri
    bool hit=false;
    float result=1.;
    for(int steps=ZERO;steps<MAXSTEPS&&(!hit)&&length(rayPos-rayOri)<MAXDIST;steps++){
        MapResult localState=map(rayPos);
        float dts=localState.dist;	//calculate distance to scene
        hit=dts<HITDIST;
        result=min(result,SHADSMOOTH*dts/length(rayPos-rayOri));//if close to a surfce, cast a penumbra
        rayPos-=sun.dir*dts*SHADQUAL;//march
    }
    result=hit ? 0.:result; //if you registered a hit, then no light for you!
    return result; //otherwise return the darkest penumbra you encountered
}

CastResult primaryRay(vec3 rayOri,vec3 rayVec){
    
    bool hit=false;
    vec3 rayPos=rayOri;
    MapResult localState;
    //the conditions here signal to break out of the loop whenever:
    //		steps taken exceeds MAXSTEPS; nothing was hit
    //or	the ray's length exceeds MAXDIST; nothing was hit
    //or	the hit flag signals a collision
    for(int steps=ZERO;steps<MAXSTEPS&&length(rayPos-rayOri)<MAXDIST&&hit==false;steps++){
        localState=map(rayPos);//get local conditions at rayPos
        float dts=localState.dist;//extract scene distance
        hit=dts<HITDIST;			  //register a hit, if the distance is small
        rayPos+=hit ? vec3(0.):rayVec*dts;//march the ray unless theres a hit
    }
    vec3 norm=calcNorm(rayPos);
    vec3 surfCol=localState.color;

    //return a CastResult struct
    return CastResult(rayOri,rayPos,norm,surfCol);
}


//calculate the light hitting this castResult from sun and ambient light
vec3 lightOn(CastResult hit,DirLight sun){
    float difLight=max(0.,(-dot(hit.norm,sun.dir)));
    #ifdef SPECULARPOWER //if SPECULARPOWER is commented out, lighting is diffuse only
    float specLight=SPECULARPOWER*
        pow(max(0.0,dot(reflect(sun.dir,hit.norm),normalize(hit.ori-hit.pos))),100.);
    vec3 sunLight=(difLight+specLight)*sun.col*occlusion(hit,sun);
    #else
    vec3 sunLight=(difLight)*sun.col*occlusion(hit,sun);
    #endif
    vec3 ambientLight=vec3(AMBIENT*ambientOcclusion(hit.pos,hit.norm,AODIST));
    return (sunLight+ambientLight);
}
  
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
//Set up the camera
    vec2 mousePos=CAMSTRT;
    float mouseTheta=mousePos.x*2.*PI;
    float mouseH=mousePos.y*30.+10.;
    vec3 camPos=vec3(cos(mouseTheta)*CAMDIST,mouseH,CAMDIST*sin(mouseTheta));
    vec3 camTarget=vec3(0.,10.*sin((iTime*GSPEED+TOFF)/2.)/3.,2.+sin((iTime*GSPEED+TOFF)/3.));
//set up lighting
    DirLight sun;
    sun.dir=SUNDIR;
    sun.col=SUNLIGHT;
//set up camera ray
    mat3 rayRotation=camRotation(camTarget-camPos);
    vec2 uv = (gl_FragCoord.xy -.5*iResolution.xy)/iResolution.y;
    vec3 rayVec=normalize(vec3(uv.x,uv.y,1.)*rayRotation);
    vec3 rayOri=camPos;
//cast the ray
    CastResult cRay=primaryRay(rayOri,rayVec);
    
    
    vec3 finalC;
    float fog=1.-exp(-length(cRay.pos-cRay.ori)*FOGDIST);
    vec3 fogColor=FOGCOL;
    if(length(cRay.pos)>20.){//if outside the structure
    //this is what gives the sun it's 'aura' by 
    //brightening the fog that is nearly antiparalel to the sunlight direction
    fogColor+=sun.col*pow(max(0.,dot(-sun.dir,rayVec)),34.);
    }
    //fogColor+=(bounce.col*pow(max(0.,dot(-bounce.dir,rayVec)),16.));
    if(fog<.99){
    bool inBounds=length(cRay.pos-rayOri)<MAXDIST*.999;

    finalC=inBounds?(lightOn(cRay,sun))*cRay.surf:fogColor;//+lightOn(cRay,bounce)
    finalC=mix(finalC,fogColor,fog);//FOG APPLICATION
    }
    else{finalC=vec3(fogColor);}
    finalC=pow(finalC,vec3(1./2.2));//GAMMA CORRECT
    gl_FragColor = vec4(finalC,1.0);
}
